#include <iostream>
#include <vector>
#include <string>
#include <algorithm>
#define int long long

using namespace std;

const int mod = 998244353;

int bin_pow(int x, int p) {
    if (p == 0) {
        return 1;
    }
    if (p & 1) return (bin_pow(x, p - 1) * x) % mod;
    int y = bin_pow(x, p >> 1);
    return (y * y) % mod;
}

void solve() {
    int n, m;
    cin >> n >> m;
    vector<vector<vector<int>>> dp(n, vector<vector<int>>(n, vector<int>(n, 0)));
    dp[0][0][0] = m;
    for (int i = 0; i < n - 1; i++) {
        for (int j = 0; j < n - 1; j++) {
            for (int o = 0; o < j; o++) {
                dp[i + 1][j][0] += (dp[i][j][o] * (m - 1)) % mod;
                dp[i + 1][j][0] %= mod;
                dp[i + 1][j][o + 1] += dp[i][j][o];
                dp[i + 1][j][o + 1] %= mod;
            }
            dp[i + 1][j + 1][j + 1] += dp[i][j][j];
            dp[i + 1][j + 1][j + 1] %= mod;
            dp[i + 1][j][0] += (dp[i][j][j] * (m - 1)) % mod;
            dp[i + 1][j][0] %= mod;
        }
    }
    int sum = 0;
    for (int i = 0; i < n; i++) {
        for (int j = 0; j < n; j++) {
            sum = (sum + (dp[n - 1][i][j] * (i + 1))) % mod;
        }
    }
    int all = bin_pow(m, n);
    cout << (sum * bin_pow(all, mod - 2)) % mod << "\n";
}

signed main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);
    cout.tie(nullptr);
    int t = 1;
    cin >> t;
    while (t-->0) {
        solve();
    }
    return 0;
}
